# 🟩 Core Essentials
*Features necessary to perform the required function*

| Feature | Description | Assessment |
|--------|-------------|------------|
| Tool Definition | Define and manage tools such as end mills, drills, inserts | |
| Tool Numbering | Assign tool numbers for G-code output | |

---

# 🟨 Professional Grade
*Features usually present or expected in the state-of-the-art applications*

| Feature                                     | Description                                                                                                                                                                                                                | Assessment |
| ------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------- |
| Tool Metadata                               | Define shapes, material, holding, and additional metadata                                                                                                                                                                  |            |
| Feeds & Speeds Suggestions                  | Recommend cutting parameters based on tool, material, and operation                                                                                                                                                        |            |
| Tool Import/Export                          | Synchronize tool definitions with machine or external databases                                                                                                                                                            |            |
| Tool Libraries                              | Manage sets of tools as reusable libraries                                                                                                                                                                                 |            |
| Probe Tool Definition                       | Identify probe tools and suppress spindle start                                                                                                                                                                            |            |
| Drag Knife Support                          | Define drag-knife tool and generate accurate offset-aware toolpaths                                                                                                                                                        |            |
| Separate tool preparation from tool loading | With larger machines, a tool magazine may take a significant amount of time to index in preparation for a tool change.  <br>We should support separating the calls to 'call for a tool'  from the call to 'load the tool'. |            |

---

# 🟦 Next-Level CAM
*Features that would exceed industry standard*

| Feature | Description | Assessment |
|--------|-------------|------------|
| *(placeholder)* | *(Add cutting-edge tool management or smart tooling features here)* | |
